/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.ContextProvider;
import com.mongodb.MongoClientSettings;
import com.mongodb.reactivestreams.client.ReactiveContextProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceRequestContext;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class TraceReactiveMongoClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer {
    public void customize(MongoClientSettings.Builder clientSettingsBuilder) {
        clientSettingsBuilder.contextProvider((ContextProvider)TraceReactiveMongoClientSettingsBuilderCustomizer.contextProvider());
    }

    static ReactiveContextProvider contextProvider() {
        return subscriber -> {
            if (subscriber instanceof CoreSubscriber) {
                return new ReactiveTraceRequestContext((ContextView)((CoreSubscriber)subscriber).currentContext());
            }
            return new ReactiveTraceRequestContext((ContextView)Context.empty());
        };
    }

    static class ReactiveTraceRequestContext
    extends TraceRequestContext {
        ReactiveTraceRequestContext(ContextView context) {
            super(new ConcurrentHashMap<Object, Object>(context.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        }
    }
}

