/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

class TraceFeignBlockingLoadBalancerClient
extends FeignBlockingLoadBalancerClient {
    private static final Log LOG = LogFactory.getLog(TraceFeignBlockingLoadBalancerClient.class);
    private final BeanFactory beanFactory;
    Tracer tracer;
    CurrentTraceContext currentTraceContext;
    HttpClientHandler httpClientHandler;
    TracingFeignClient tracingFeignClient;

    TraceFeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancerClientsProperties loadBalancerProperties, LoadBalancerClientFactory loadBalancerClientFactory, BeanFactory beanFactory) {
        super(delegate, loadBalancerClient, (LoadBalancerProperties)loadBalancerProperties, loadBalancerClientFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Before send");
        }
        Response response = null;
        Span fallbackSpan = this.tracer().nextSpan().start();
        try {
            response = this.delegateIsALoadBalancer() ? this.getDelegate().execute(request, options) : super.execute(request, options);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After receive");
            }
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception thrown", (Throwable)e);
            }
            if (e instanceof IOException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IOException was thrown, so most likely the traced client wasn't called. Falling back to a manual span.");
                }
                this.tracingFeignClient().handleSendAndReceive(fallbackSpan, request, response, e);
            }
            throw e;
        }
        finally {
            fallbackSpan.abandon();
        }
    }

    private boolean delegateIsALoadBalancer() {
        return this.getDelegate() instanceof FeignBlockingLoadBalancerClient;
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    private HttpClientHandler httpClientHandler() {
        if (this.httpClientHandler == null) {
            this.httpClientHandler = (HttpClientHandler)this.beanFactory.getBean(HttpClientHandler.class);
        }
        return this.httpClientHandler;
    }

    private TracingFeignClient tracingFeignClient() {
        if (this.tracingFeignClient == null) {
            this.tracingFeignClient = (TracingFeignClient)TracingFeignClient.create(this.currentTraceContext(), this.httpClientHandler(), this.getDelegate());
        }
        return this.tracingFeignClient;
    }
}

